package Module::Features::PasswordManager;

use 5.010001;
use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2025-01-19'; # DATE
our $DIST = 'Module-Features-PasswordManager'; # DIST
our $VERSION = '0.001'; # VERSION

our %FEATURES_DEF = (
    v => 1,
    summary => 'Features of password managers',
    description => <<'MARKDOWN',

Password manager is a tool that lets you input, store, and retrieve individual
passwords securely.

MARKDOWN
    features => {
        can_add_password                         => {summary => 'Provide an interface to add a password into its database'},
        can_add_note                             => {summary => 'When adding a password, can add a note field'},
        can_add_custom_fields                    => {summary => 'When adding a password, can add custom fields'},

        can_edit_password                        => {summary => 'Provide an interface to edit existing password'},
        can_record_edit_history                  => {summary => 'When editing password, record previous data or change history'},

        can_delete_password                      => {summary => 'Provide an interface to delete existing password'},

        can_retrieve_password                    => {summary => 'Provide an interface to retrieve a single password from database'},
        can_dump_passwords                       => {summary => 'Provide an interface to dump all/several passwords from database'},

        can_encrypt_password                     => {summary => 'Whether passwords are stored encrypted in the database'},
        can_encrypt_label                        => {summary => 'Whether password labels are stored encrypted in the database'},
        can_encrypt_other_fields                 => {summary => 'Whether fields other than the password and label are stored encrypted in the database'},

        database_format                          => {summary => 'Database format', schema=>['str']},
        database_format_is_open_standard         => {summary => 'Whether database format is an open standard'},
        encryption_format                        => {summary => 'Database encryption format', schema=>['str']},
        encryption_format_is_open_standard       => {summary => 'Whether encryption format is an open standard'},
    },
);

1;
# ABSTRACT:

__END__

=pod

=encoding UTF-8

=head1 NAME

Module::Features::PasswordManager

=head1 VERSION

This document describes version 0.001 of Module::Features::PasswordManager (from Perl distribution Module-Features-PasswordManager), released on 2025-01-19.

=head1 DESCRIPTION

Password manager is a tool that lets you input, store, and retrieve individual
passwords securely.

=head1 DEFINED FEATURES

Features defined by this module:

=over

=item * can_add_custom_fields

Optional. Type: bool. When adding a password, can add custom fields. 

=item * can_add_note

Optional. Type: bool. When adding a password, can add a note field. 

=item * can_add_password

Optional. Type: bool. Provide an interface to add a password into its database. 

=item * can_delete_password

Optional. Type: bool. Provide an interface to delete existing password. 

=item * can_dump_passwords

Optional. Type: bool. Provide an interface to dump all/several passwords from database. 

=item * can_edit_password

Optional. Type: bool. Provide an interface to edit existing password. 

=item * can_encrypt_label

Optional. Type: bool. Whether password labels are stored encrypted in the database. 

=item * can_encrypt_other_fields

Optional. Type: bool. Whether fields other than the password and label are stored encrypted in the database. 

=item * can_encrypt_password

Optional. Type: bool. Whether passwords are stored encrypted in the database. 

=item * can_record_edit_history

Optional. Type: bool. When editing password, record previous data or change history. 

=item * can_retrieve_password

Optional. Type: bool. Provide an interface to retrieve a single password from database. 

=item * database_format

Optional. Type: str. Database format. 

=item * database_format_is_open_standard

Optional. Type: bool. Whether database format is an open standard. 

=item * encryption_format

Optional. Type: str. Database encryption format. 

=item * encryption_format_is_open_standard

Optional. Type: bool. Whether encryption format is an open standard. 

=back

For more details on module features, see L<Module::Features>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Module-Features-PasswordManager>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Module-Features-PasswordManager>.

=head1 SEE ALSO

L<Module::Features>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2025 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Module-Features-PasswordManager>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
