/*                                                                
**  Copyright (C) 2019  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* f77.h
**
**
**
**/


#ifndef _CXCPARAM_F77_H
#define _CXCPARAM_F77_H

#include "config.h"

void strc2f (char *cstring, char *fstring, int length);
char *strf2c (int length, char *string, char *cstring);
char **GetF77argv (int *argc);

/* define the Fortran accessible functions. Why? 'cause we use gcc's --Werror=missing-prototypes
   to keep the code clean and it doesn't like global functions which don't have prototypes
 */

#define UERGET_F77 F77_FUNC(uerget,UERGET)
void UERGET_F77 (int *errcode, char *text, int ntext);

#define PARAMOPEN_F77 F77_FUNC(paramopen,PARAMOPEN)
void PARAMOPEN_F77 (char *filename, char *mode, ParamFile * pf, int nfilename,
		    int nmode);

#define PARAMLIST_F77 F77_FUNC(paramlist,PARAMLIST)
void PARAMLIST_F77 (ParamFile * pfile);

#define PARAMCLOSE_F77 F77_FUNC(paramclose,PARAMCLOSE)
void PARAMCLOSE_F77 (ParamFile * pfile);

#define PARAMFIND_F77 F77_FUNC(paramfind,PARAMFIND)
void PARAMFIND_F77 (char *name, char *path, int nname, int npath);

#define PARAMERR_F77 F77_FUNC(paramerr,PARAMERR)
void PARAMERR_F77 (int *level, char *message, char *name, int nmessage,
		   int nname);

#define PARAMERRSTR_F77 F77_FUNC(paramerrstr,PARAMERRSTR)
void PARAMERRSTR_F77 (char *errstr, int nerrstr);

#define PGETSTR_F77 F77_FUNC(pgetstr,PGETSTR)
void PGETSTR_F77 (ParamFile * pfile, char *name, char *string, int *status,
		  int nname, int nstring);

#define PPUTSTR_F77 F77_FUNC(pputstr,PPUTSTR)
void PPUTSTR_F77 (ParamFile * pfile, char *name, char *string, int *status,
		  int nname, int nstring);


#endif /* ! _CXCPARAM_F77_H */
