package Doubly::Linked;

use 5.006;
use strict;
use warnings;
our $VERSION = '0.01';

require XSLoader;
XSLoader::load('Doubly::Linked', $VERSION);

1;

__END__

=head1 NAME

Doubly::Linked - Doubly linked lists

=head1 VERSION

Version 0.01

=cut

=head1 SYNOPSIS

	use Doubly::Linked;

	my $list = Doubly::Linked->new();

	$list->insert_at_start(1);
	$list = $list->insert_at_end(2);
	$list->insert_after(3);

	$list = $list->start;
	$list = $list->next;
	$list = $list->prev;

	$list->data;
	$list->data($new_data);

	$list->remove;

=head1 SUBROUTINES/METHODS

=head1 AUTHOR

LNATION, C<< <email at lnation.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-doubly-linked at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=Doubly-Linked>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Doubly::Linked


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=Doubly-Linked>

=item * CPAN Ratings

L<https://cpanratings.perl.org/d/Doubly-Linked>

=item * Search CPAN

L<https://metacpan.org/release/Doubly-Linked>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2025 by LNATION.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)


=cut

1; # End of Doubly::Linked
